/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.watch.checks;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.errors.InvalidAttributeValue;
import com.floragunn.codova.validation.errors.MissingAttribute;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.signals.execution.CheckExecutionException;
import com.floragunn.signals.execution.WatchExecutionContext;
import com.floragunn.signals.support.NestedValueMap;
import com.floragunn.signals.watch.checks.Calc;
import com.floragunn.signals.watch.checks.Condition;
import com.floragunn.signals.watch.checks.HttpInput;
import com.floragunn.signals.watch.checks.SearchInput;
import com.floragunn.signals.watch.checks.SearchTemplateInput;
import com.floragunn.signals.watch.checks.StaticInput;
import com.floragunn.signals.watch.checks.Transform;
import com.floragunn.signals.watch.common.WatchElement;
import com.floragunn.signals.watch.init.WatchInitializationService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class Check
extends WatchElement {
    protected final String name;

    Check(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " " + this.name;
    }

    protected Map<String, Object> getTemplateScriptParamsAsMap(WatchExecutionContext ctx) {
        return ctx.getTemplateScriptParamsAsMap();
    }

    public abstract boolean execute(WatchExecutionContext var1) throws CheckExecutionException;

    static Check create(WatchInitializationService watchInitService, DocNode jsonNode) throws ConfigValidationException {
        String type;
        if (!jsonNode.hasNonNull("type")) {
            throw new ConfigValidationException((ValidationError)new MissingAttribute("type", (Object)jsonNode));
        }
        switch (type = jsonNode.getAsString("type")) {
            case "search": {
                if (jsonNode.hasNonNull("template")) {
                    return SearchTemplateInput.create(watchInitService, jsonNode);
                }
                return SearchInput.create(watchInitService, jsonNode);
            }
            case "static": {
                return StaticInput.create(jsonNode);
            }
            case "http": {
                return HttpInput.create(watchInitService, jsonNode);
            }
            case "condition": 
            case "condition.script": {
                return Condition.create(watchInitService, jsonNode);
            }
            case "calc": {
                return Calc.create(watchInitService, jsonNode);
            }
            case "transform": {
                return Transform.create(watchInitService, jsonNode);
            }
        }
        throw new ConfigValidationException((ValidationError)new InvalidAttributeValue("type", (Object)type, (Object)"search|static|http|condition|calc|transform", (Object)jsonNode));
    }

    public static Map<String, Object> getIndexMapping() {
        NestedValueMap result = new NestedValueMap();
        result.put("dynamic", (Object)true);
        NestedValueMap properties = new NestedValueMap();
        SearchInput.addIndexMappingProperties(properties);
        StaticInput.addIndexMappingProperties(properties);
        result.put("properties", properties);
        return result;
    }

    public static Map<String, Object> getIndexMappingUpdate() {
        NestedValueMap result = new NestedValueMap();
        NestedValueMap properties = new NestedValueMap();
        StaticInput.addIndexMappingProperties(properties);
        result.put("properties", properties);
        return result;
    }

    public static List<Check> create(WatchInitializationService watchInitService, List<?> checkNodes) throws ConfigValidationException {
        ArrayList<Check> result = new ArrayList<Check>(checkNodes.size());
        ValidationErrors validationErrors = new ValidationErrors();
        for (Object o : checkNodes) {
            DocNode member = DocNode.wrap(o);
            try {
                result.add(Check.create(watchInitService, member));
            }
            catch (ConfigValidationException e) {
                validationErrors.add(member.hasNonNull("name") ? "[" + member.getAsString("name") + "]" : "[]", e);
            }
        }
        validationErrors.throwExceptionForPresentErrors();
        return result;
    }
}

